/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package chapter9.date;

import chapter9.datetime.*;
import java.time.LocalDate;
import static java.time.temporal.ChronoUnit.YEARS;

/** 
 * @author Matthew Gregory
 * website: www.matthewgregory-author.com.au
 *
 */
public class Person {

    public String firstName;
    public String lastName;
    public String type;
//    public int age;
    public LocalDate birthday;
    
    //Constructor
    public Person(String type, String firstName, String lastName, LocalDate birthday) {
        this.type=checkType(type);
        setNames(firstName,lastName);
        this.birthday=birthday;
    }
    
    public Person() {
    }

    public String getFullName(){
        return Utilities.capitalise(firstName+" "+lastName);
    }
    
    public long getAge(){
        //What is the date today?
        LocalDate today = LocalDate.now();
        //What is the difference between today's date and birthday
        long age = YEARS.between(birthday,today);
        return age;
    }
    
    public void printDetails(){
        System.out.println("First Name: "+firstName);
        System.out.println("Last Name: "+lastName);
        System.out.println("Full Name: "+getFullName());
//        System.out.println("Birthday: "+birthday);
        System.out.println("Age: "+getAge());
    }

    public void setNames(String firstName, String lastName){
        this.firstName = firstName.toUpperCase();
        this.lastName = lastName.toUpperCase();
    } 
    
    public String checkType(String type){
        //Using exceptions to make sure type is either employee or customer.
        if (type != "Employee"&&type!= "Customer"){
            throw new RuntimeException("Warning you have specified a type of "+type+". Type should be either Employee or Customer");
        } else {
            return type;
        }
    }
    
    public String toString(){
        return getFullName();
    }
    
}
